<style>
    body {
        background-color: black;
        color: white;
        font-family: sans-serif;
    }
    a.button-link, button.submit-button {
        display: inline-block;
        padding: 10px 20px;
        background-color: #007bff;
        color: white;
        text-align: center;
        text-decoration: none;
        border-radius: 5px;
        border: none;
        cursor: pointer;
        font-size: 16px;
    }
    a.button-link:hover, button.submit-button:hover {
        background-color: #0056b3;
    }
    ul {
        list-style-type: none;
        padding: 0;
    }
    li {
        margin-bottom: 5px;
    }
    hr {
        border-color: #333;
        margin: 20px 0;
    }
    .pagination {
        margin-top: 20px;
    }
    .pagination a {
        padding: 8px 16px;
        text-decoration: none;
        color: white;
        border: 1px solid #007bff;
        margin: 0 4px;
        border-radius: 5px;
    }
    .pagination a.active {
        background-color: #007bff;
        color: white;
    }
    .search-form {
        margin-bottom: 20px;
    }
    .search-form input {
        padding: 8px;
        margin-right: 5px;
        border: 1px solid #555;
        background-color: #333;
        color: white;
        border-radius: 5px;
    }
</style>

<?php

echo "<h1>Geocoding</h1>";
echo "<a href='./viewlog.php' class='button-link'>Kembali ke Log</a>";
echo "<hr>";

// ======================= FORM PENCARIAN =======================
echo "<form class='search-form' action='geocoding.php' method='get'>";
echo "<h3>Cari Koordinat</h3>";
echo "<input type='text' name='lat' placeholder='Latitude' value='" . htmlspecialchars($_GET['lat'] ?? '') . "'>";
echo "<input type='text' name='lon' placeholder='Longitude' value='" . htmlspecialchars($_GET['lon'] ?? '') . "'>";
echo "<button type='submit' class='submit-button'>Cari</button>";
echo "</form>";
echo "<hr>";

// ======================= LOGIKA GEOCoding =======================
// Periksa apakah ada input dari form pencarian
if (isset($_GET['lat']) && isset($_GET['lon']) && !empty($_GET['lat']) && !empty($_GET['lon'])) {
    
    // Logika untuk satu koordinat dari form
    $latitude = htmlspecialchars($_GET['lat']);
    $longitude = htmlspecialchars($_GET['lon']);
    
    // Validasi input
    if (is_numeric($latitude) && is_numeric($longitude)) {
        echo "<h2>Hasil Pencarian:</h2>";
        
        // URL API Nominatim untuk reverse geocoding
        $url = "https://nominatim.openstreetmap.org/reverse?format=json&lat=$latitude&lon=$longitude&addressdetails=1";

        $options = [
            'http' => ['header' => 'User-Agent: MyPHPApp/1.0 (my.email@example.com)']
        ];
        $context = stream_context_create($options);

        $response = @file_get_contents($url, false, $context);
        $data = json_decode($response);
        
        echo "<h3>Koordinat: $latitude, $longitude</h3>";

        if ($data && isset($data->address)) {
            echo "<p><strong>Nama Lengkap:</strong> " . htmlspecialchars($data->display_name) . "</p>";
            echo "<h4>Detail Alamat:</h4>";
            echo "<ul>";
            foreach ($data->address as $key => $value) {
                echo "<li><strong>" . htmlspecialchars(ucfirst($key)) . ":</strong> " . htmlspecialchars($value) . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>Tidak dapat menemukan alamat untuk koordinat ini.</p>";
        }
        
    } else {
        echo "<p>Error: Input latitude dan longitude harus berupa angka.</p>";
    }
    
} else {
    // Logika default: membaca dari file data_real.txt
    
    // 1. Membaca isi dari file data_real.txt
    $file_content = @file_get_contents('data_real.txt');

    if ($file_content === false) {
        die("Error: Gagal membaca file data_real.txt.");
    }

    // 2. Menggunakan ekspresi reguler untuk mengambil semua pasangan latitude dan longitude
    $pattern = '/Latitude\s*:\s*([\d.-]+)\s*Longtitude\s*:\s*([\d.-]+)/';
    preg_match_all($pattern, $file_content, $matches, PREG_SET_ORDER);

    if (empty($matches)) {
        die("Tidak ada data latitude dan longitude yang ditemukan di file.");
    }

    $matches = array_reverse($matches);

    // ======================= PENGATURAN PAGINATION =======================
    $results_per_page = 2;
    $total_results = count($matches);
    $total_pages = ceil($total_results / $results_per_page);

    $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    if ($current_page < 1) $current_page = 1;
    if ($current_page > $total_pages) $current_page = $total_pages;

    $offset = ($current_page - 1) * $results_per_page;
    $matches_to_display = array_slice($matches, $offset, $results_per_page);

    echo "<h2>Hasil Geocoding</h2>";

    foreach ($matches_to_display as $match) {
        $latitude = $match[1];
        $longitude = $match[2];

        $url = "https://nominatim.openstreetmap.org/reverse?format=json&lat=$latitude&lon=$longitude&addressdetails=1";

        $options = [
            'http' => ['header' => 'User-Agent: MyPHPApp/1.0 (my.email@example.com)']
        ];
        $context = stream_context_create($options);

        $response = @file_get_contents($url, false, $context);
        $data = json_decode($response);

        echo "<h3>Koordinat: $latitude, $longitude</h3>";

        if ($data && isset($data->address)) {
            echo "<p><strong>Nama Lengkap:</strong> " . htmlspecialchars($data->display_name) . "</p>";
            echo "<h4>Detail Alamat:</h4>";
            echo "<ul>";
            foreach ($data->address as $key => $value) {
                echo "<li><strong>" . htmlspecialchars(ucfirst($key)) . ":</strong> " . htmlspecialchars($value) . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>Tidak dapat menemukan alamat untuk koordinat ini.</p>";
        }

        echo "<hr>";
        sleep(1);
    }

    // ======================= TAMPILKAN PAGINATION LINKS =======================
    echo "<div class='pagination'>";
    if ($current_page > 1) {
        echo "<a href='geocoding.php?page=" . ($current_page - 1) . "'>&laquo; Sebelumnya</a>";
    }

    for ($i = 1; $i <= $total_pages; $i++) {
        $active_class = ($i == $current_page) ? 'active' : '';
        echo "<a href='geocoding.php?page=$i' class='$active_class'>$i</a>";
    }

    if ($current_page < $total_pages) {
        echo "<a href='geocoding.php?page=" . ($current_page + 1) . "'>Berikutnya &raquo;</a>";
    }
    echo "</div>";
}
?>