

<?php

// ===========================================
// ======***========***====***====***=========
// ======*****======***====***===***==========
// ======***=***====***====***=***============
// ======***==***===***====******=============
// ======***===***==***====***=***============
// ======***====***=***====***==***===========
// ======***=====******====***====***=========
// ===========================================

// Daftar alamat IP yang diblokir (termasuk wildcard)
$blocked_ips = [
    // "38.9.155.*", //urban vpn
    // "45.64.98.*", //urban vpn
        "93.185.*.*", //surfshark
        "185.213.*.*", //nordvpn
        "45.8.*.*", //express vpn
        "185.213.83.*", //agen
        "185.213.83.*", //agen
        "103.168.147.*", //agen
        "103.164.173.*", //agen
        "103.52.212.*", //agen
        "202.67.45.*", //agen
        "114.125.68.*", //agen
        "103.215.72.*", //agen
        "103.77.106.*", //agen
        "103.147.32.*", //agen
        "182.2.104.*", //agen
        "180.242.69.*", //agen
        "45.198.2.*", //agen
        "103.164.173.*", //agen
        "146.75.160.*", //agen
        "172.225.180.*", //agen
        "103.78.218.*", //agen
        "8.215.36.*", //agen
        "185.213.83.*", //agen
        "114.125.69.*", //agen
        "103.156.114.*", //agen
        "45.64.98.*", //agen
        "103.216.223.*", //agen
        "103.11.218.*", //agen
        "185.213.83.*", //agen
        "103.119.154.*", //agen
        "104.28.119.*", //agen
        "103.17.215.*", //agen
        "103.168.147.*", //agen
        "103.164.173.*", //agen
        "103.52.212.*", //agen
        "202.67.45.*", //agen
        "58.97.192.*", //agen
        "103.52.212.*", //agen
        "114.125.68.*", //agen
        "104.28.120.*", //agen
        " 103.25.92.*", //agen
        " 43.245.203.*", //agen
        "103.9.188.*", //agen
        "103.17.213.*", //agen
        " 209.146.23.*", //agen
        "103.215.72.*", //agen

    ];

// Konfigurasi dan inisialisasi
define('API_GEOLOCATION', 'http://ip-api.com/json/');
define('API_VPN_CHECK', 'https://blackbox.ipinfo.app/lookup/');

/**
 * Mengambil alamat IP pengguna secara aman.
 * Prioritas: IP di balik proxy, lalu IP asli.
 * @return string Alamat IP yang ditemukan atau 'UNKNOWN'.
 */
function getClientIP() {
    // Cek IP dari header proxy yang paling umum
    $ipKeys = [
        'HTTP_CLIENT_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_FORWARDED',
        'HTTP_FORWARDED_FOR',
        'HTTP_FORWARDED',
        'REMOTE_ADDR'
    ];

    foreach ($ipKeys as $key) {
        if (!empty($_SERVER[$key])) {
            $ipList = explode(',', $_SERVER[$key]);
            foreach ($ipList as $ip) {
                $ip = trim($ip);
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
                    return $ip;
                }
            }
        }
    }
    return 'UNKNOWN';
}

/**
 * Mendapatkan data geolokasi dari IP.
 * Menggunakan cURL dengan timeout untuk efisiensi.
 * @param string $ip Alamat IP.
 * @return array|null Data geolokasi dalam array, atau null jika gagal.
 */
function getGeoLocation($ip) {
    $ch = curl_init(API_GEOLOCATION . $ip);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Timeout 5 detik
    $json = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200 && $json) {
        return json_decode($json, true);
    }
    return null;
}

/**
 * Mengecek apakah IP adalah VPN atau proxy.
 * Menggunakan cURL dengan timeout.
 * @param string $ip Alamat IP.
 * @return bool True jika terdeteksi VPN, False jika tidak.
 */
function isVPN($ip) {
    $ch = curl_init(API_VPN_CHECK . $ip);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Timeout 5 detik
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return ($httpCode === 200 && trim($result) === 'Y');
}

/**
 * Mengecek apakah pengguna menggunakan perangkat mobile.
 * @return bool True jika mobile, False jika tidak.
 */
function isMobile() {
    return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER['HTTP_USER_AGENT']);
}

   // Catatan Log pengunjung -----------------------------------------------------------------------------------------------------------------------
$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'Tidak Ada Referer';
$country = $geoLocationData['country'];
$useragent = $_SERVER["HTTP_USER_AGENT"];
$request_timestamp  = $_SERVER['REQUEST_TIME'];
$request_datetime = date('Y-m-d H:i:s', $request_timestamp);

// Mendeteksi Perangkat Mobile
if (strpos($useragent, 'Mobile') !== false) {
    $gadget = "Mobile";
} else {
    $gadget = "Desktop";
}
// Mendeteksi Sistem Operasi
if (strpos($useragent, 'Windows NT') !== false) {
    $os = "Windows";
} elseif (strpos($useragent, 'Mac OS') !== false) {
    $os = "Mac";
} elseif (strpos($useragent, 'Android') !== false) {
    $os = "Android";
} elseif (strpos($useragent, 'iOS') !== false) {
    $os = "iOS";
}
$geoplugin_latitude = $geoLocationData['latitude'];
$geoplugin_longitude = $geoLocationData['longitude'];

// Bagian PHP
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['latitude']) && isset($_POST['longitude'])) {
        $latitude = $_POST['latitude'];
        $longitude = $_POST['longitude'];

        // echo "<h1>Lokasi Anda Berhasil Disimpan!</h1>";
        // echo "<p><strong>Latitude:</strong> " . htmlspecialchars($latitude) . "</p>";
        // echo "<p><strong>Longitude:</strong> " . htmlspecialchars($longitude) . "</p>";
        
    } else {
        echo "<p>Gagal menerima data lokasi.</p>";
    }
} else {
    $latitude = "";
    $longitude = "";
    // echo "<h1>Meminta Lokasi Anda...</h1>";
    // Pesan ini akan muncul sebelum permintaan izin lokasi muncul di browser
    // dan akan diganti setelah data lokasi diterima.
}

?>